%------------------------------------------------------------------------------
% File     : SEV473^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Analysis
% Problem  : FINITE_FINITE_UNIONS
% Version  : Especial.
% English  :

% Refs     : [Kal16] Kalisyk (2016), Email to Geoff Sutcliffe
% Source   : [Kal16]
% Names    : FINITE_FINITE_UNIONS_.p [Kal16]

% Status   : Theorem
% Rating   : 1.00 v7.1.0
% Syntax   : Number of formulae    :   14 (   4 unt;   6 typ;   0 def)
%            Number of atoms       :   32 (   6 equ;   0 cnn)
%            Maximal formula atoms :    3 (   4 avg)
%            Number of connectives :   69 (   1   ~;   1   |;   2   &;  60   @)
%                                         (   0 <=>;   5  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   6 avg)
%            Number of types       :    1 (   0 usr)
%            Number of type conns  :   36 (  36   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    7 (   6 usr;   0 con; 2-4 aty)
%            Number of variables   :   28 (   0   ^;  22   !;   0   ?;  28   :)
%                                         (   6  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : Exported from core HOL Light.
%------------------------------------------------------------------------------
thf('thf_const_const/sets/UNIONS',type,
    'const/sets/UNIONS': 
      !>[A: $tType] : ( ( ( A > $o ) > $o ) > A > $o ) ).

thf('thf_const_const/sets/UNION',type,
    'const/sets/UNION': 
      !>[A: $tType] : ( ( A > $o ) > ( A > $o ) > A > $o ) ).

thf('thf_const_const/sets/INSERT',type,
    'const/sets/INSERT': 
      !>[A: $tType] : ( A > ( A > $o ) > A > $o ) ).

thf('thf_const_const/sets/IN',type,
    'const/sets/IN': 
      !>[A: $tType] : ( A > ( A > $o ) > $o ) ).

thf('thf_const_const/sets/FINITE',type,
    'const/sets/FINITE': 
      !>[A: $tType] : ( ( A > $o ) > $o ) ).

thf('thf_const_const/sets/EMPTY',type,
    'const/sets/EMPTY': 
      !>[A: $tType] : ( A > $o ) ).

thf('thm/sets/FINITE_INDUCT_',axiom,
    ! [A: $tType,A0: ( A > $o ) > $o] :
      ( ( ( A0 @ ( 'const/sets/EMPTY' @ A ) )
        & ! [A1: A,A2: A > $o] :
            ( ( A0 @ A2 )
           => ( A0 @ ( 'const/sets/INSERT' @ A @ A1 @ A2 ) ) ) )
     => ! [A1: A > $o] :
          ( ( 'const/sets/FINITE' @ A @ A1 )
         => ( A0 @ A1 ) ) ) ).

thf('thm/sets/FINITE_UNION_',axiom,
    ! [A: $tType,A0: A > $o,A1: A > $o] :
      ( ( 'const/sets/FINITE' @ A @ ( 'const/sets/UNION' @ A @ A0 @ A1 ) )
      = ( ( 'const/sets/FINITE' @ A @ A0 )
        & ( 'const/sets/FINITE' @ A @ A1 ) ) ) ).

thf('thm/sets/FINITE_RULES_0',axiom,
    ! [A: $tType] : ( 'const/sets/FINITE' @ A @ ( 'const/sets/EMPTY' @ A ) ) ).

thf('thm/sets/IN_INSERT_',axiom,
    ! [A: $tType,A0: A,A1: A,A2: A > $o] :
      ( ( 'const/sets/IN' @ A @ A0 @ ( 'const/sets/INSERT' @ A @ A1 @ A2 ) )
      = ( ( A0 = A1 )
        | ( 'const/sets/IN' @ A @ A0 @ A2 ) ) ) ).

thf('thm/sets/UNIONS_INSERT_',axiom,
    ! [A: $tType,A0: A > $o,A1: ( A > $o ) > $o] :
      ( ( 'const/sets/UNIONS' @ A @ ( 'const/sets/INSERT' @ ( A > $o ) @ A0 @ A1 ) )
      = ( 'const/sets/UNION' @ A @ A0 @ ( 'const/sets/UNIONS' @ A @ A1 ) ) ) ).

thf('thm/sets/NOT_IN_EMPTY_',axiom,
    ! [A: $tType,A0: A] :
      ~ ( 'const/sets/IN' @ A @ A0 @ ( 'const/sets/EMPTY' @ A ) ) ).

thf('thm/sets/UNIONS_0_',axiom,
    ! [A: $tType] :
      ( ( 'const/sets/UNIONS' @ A @ ( 'const/sets/EMPTY' @ ( A > $o ) ) )
      = ( 'const/sets/EMPTY' @ A ) ) ).

thf('thm/sets/FINITE_FINITE_UNIONS_',conjecture,
    ! [A: $tType,A0: ( A > $o ) > $o] :
      ( ( 'const/sets/FINITE' @ ( A > $o ) @ A0 )
     => ( ( 'const/sets/FINITE' @ A @ ( 'const/sets/UNIONS' @ A @ A0 ) )
        = ( ! [A1: A > $o] :
              ( ( 'const/sets/IN' @ ( A > $o ) @ A1 @ A0 )
             => ( 'const/sets/FINITE' @ A @ A1 ) ) ) ) ) ).

%------------------------------------------------------------------------------
